local c;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
local Pulse = THEME:GetMetric("Combo", "PulseCommand");
local PulseLabel = THEME:GetMetric("Combo", "PulseLabelCommand");

local NumberMinZoom = THEME:GetMetric("Combo", "NumberMinZoom");
local NumberMaxZoom = THEME:GetMetric("Combo", "NumberMaxZoom");
local NumberMaxZoomAt = THEME:GetMetric("Combo", "NumberMaxZoomAt");

local LabelMinZoom = THEME:GetMetric("Combo", "LabelMinZoom");
local LabelMaxZoom = THEME:GetMetric("Combo", "LabelMaxZoom");

local t = Def.ActorFrame {
 	LoadActor(THEME:GetPathG("Combo","100Milestone")) .. {
		Name="OneHundredMilestone";
		FiftyMilestoneCommand=function(self) self:playcommand("Milestone") end;
	};
	InitCommand=function(self) self:vertalign(bottom) end;
	LoadFont( "_souses", "combo" ) .. {
		Name="Number";
		OnCommand = THEME:GetMetric("Combo", "NumberOnCommand");
	};
	LoadFont("_risque 36px") .. {
		Name="Label";
		OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
	};

	InitCommand = function(self)
		-- We'll have to deal with this later
		--self:draworder(notefield_draw_order.over_field)
		c = self:GetChildren();
		c.Number:visible(false);
		c.Label:visible(false);
	end;
	-- Milestones:
	-- 25,50,100,250,600 Multiples;
--[[ 		if (iCombo % 100) == 0 then
			c.OneHundredMilestone:playcommand("Milestone");
		elseif (iCombo % 250) == 0 then
			-- It should really be 1000 but thats slightly unattainable, since
			-- combo doesnt save over now.
			c.OneThousandMilestone:playcommand("Milestone");
		else
			return
		end; --]]
	TwentyFiveMilestoneCommand=function(self,parent)
		self:skewy(-0.125):decelerate(0.325):skewy(0)
	end;
	ComboCommand=function(self, param)
		local iCombo = param.Misses or param.Combo;
		if not iCombo or iCombo < ShowComboAt then
			c.Number:settext(""):visible(false);
			c.Label:visible(false);
			return;
		end

		local labeltext = "";
		if param.Combo then
			labeltext = "COMBO";
-- 			c.Number:playcommand("Reset");
		else
			labeltext = "MISSES";
-- 			c.Number:playcommand("Miss");
		end
		c.Label:settext( labeltext );
		c.Label:visible(false);

		param.Zoom = scale( iCombo, 0, NumberMaxZoomAt, NumberMinZoom, NumberMaxZoom );
		param.Zoom = clamp( param.Zoom, NumberMinZoom, NumberMaxZoom );

		param.LabelZoom = scale( iCombo, 0, NumberMaxZoomAt, LabelMinZoom, LabelMaxZoom );
		param.LabelZoom = clamp( param.LabelZoom, LabelMinZoom, LabelMaxZoom );

		c.Number:visible(true);
		c.Label:visible(true);
		c.Number:settext( string.format("%i", iCombo) );
		-- FullCombo Rewards
		if param.FullComboW1 then
			c.Number:diffuse(color("#F1CFF0")):diffusebottomedge(color("#FAABE1"))
			c.Label:diffuse(color("#F1CFF0")):diffusebottomedge(color("#FAABE1")):strokecolor(color("#A1216E"));
		elseif param.FullComboW2 then
			c.Number:diffuse(color("#D7F6F9")):diffusebottomedge(color("#8BB4F8"))
			c.Label:diffuse(color("#D7F6F9")):diffusebottomedge(color("#8BB4F8")):strokecolor(color("#3A607C"));
		elseif param.FullComboW3 then
			c.Number:diffuse(color("#D5FFB5")):diffusebottomedge(color("#D5FFB5"))
			c.Label:diffuse(color("#D5FFB5")):diffusebottomedge(color("#D5FFB5")):strokecolor(color("#12530E"));
		elseif param.Combo then
			c.Number:diffuse(color("#F3F0FE")):diffusebottomedge(color("#FFFFFF"))
			c.Label:diffuse(color("#F3F0FE")):diffusebottomedge(color("#FFFFFF")):strokecolor(color("#55476B"));
		else
			c.Number:diffuse(color("#F64C57")):diffusebottomedge(color("#FA9299"))
			c.Label:diffuse(color("#F64C57")):diffusebottomedge(color("#FA9299")):strokecolor(color("#000000"));
		end
		-- Pulse
		Pulse( c.Number, param );
		PulseLabel( c.Label, param );
		-- Milestone Logic
	end;
};

return t;
